/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.redis.clients.jedis.search.schemafields;

import net.impactdev.impactor.relocations.redis.clients.jedis.CommandArguments;
import net.impactdev.impactor.relocations.redis.clients.jedis.search.FieldName;
import net.impactdev.impactor.relocations.redis.clients.jedis.search.SearchProtocol;
import net.impactdev.impactor.relocations.redis.clients.jedis.search.schemafields.SchemaField;

public class TextField
extends SchemaField {
    private boolean sortable;
    private boolean sortableUNF;
    private boolean noStem;
    private boolean noIndex;
    private String phoneticMatcher;
    private Double weight;
    private boolean withSuffixTrie;

    public TextField(String fieldName) {
        super(fieldName);
    }

    public TextField(FieldName fieldName) {
        super(fieldName);
    }

    public static TextField of(String fieldName) {
        return new TextField(fieldName);
    }

    public static TextField of(FieldName fieldName) {
        return new TextField(fieldName);
    }

    @Override
    public TextField as(String attribute) {
        super.as(attribute);
        return this;
    }

    public TextField sortable() {
        this.sortable = true;
        return this;
    }

    public TextField sortableUNF() {
        this.sortableUNF = true;
        return this;
    }

    public TextField sortableUnNormalizedForm() {
        return this.sortableUNF();
    }

    public TextField noStem() {
        this.noStem = true;
        return this;
    }

    public TextField noIndex() {
        this.noIndex = true;
        return this;
    }

    public TextField phonetic(String matcher) {
        this.phoneticMatcher = matcher;
        return this;
    }

    public TextField weight(double weight) {
        this.weight = weight;
        return this;
    }

    public TextField withSuffixTrie() {
        this.withSuffixTrie = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        args2.addParams(this.fieldName);
        args2.add(SearchProtocol.SearchKeyword.TEXT);
        if (this.weight != null) {
            args2.add(SearchProtocol.SearchKeyword.WEIGHT).add(this.weight);
        }
        if (this.noStem) {
            args2.add(SearchProtocol.SearchKeyword.NOSTEM);
        }
        if (this.phoneticMatcher != null) {
            args2.add(SearchProtocol.SearchKeyword.PHONETIC).add(this.phoneticMatcher);
        }
        if (this.withSuffixTrie) {
            args2.add(SearchProtocol.SearchKeyword.WITHSUFFIXTRIE);
        }
        if (this.sortableUNF) {
            args2.add(SearchProtocol.SearchKeyword.SORTABLE).add(SearchProtocol.SearchKeyword.UNF);
        } else if (this.sortable) {
            args2.add(SearchProtocol.SearchKeyword.SORTABLE);
        }
        if (this.noIndex) {
            args2.add(SearchProtocol.SearchKeyword.NOINDEX);
        }
    }
}

